<!DOCTYPE html>
<html>
<head>
    <title>Invoice</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
        }

        h3 {
            color: #4f46e5;
        }

        table {
            border-collapse: collapse;
            width: 100%;
            font-size: 13px;
            line-height: 1.2;
            margin: 2px 0;
        }

        th, td {
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        .details-row::after {
            content: "";
            display: table;
            clear: both;
        }

        .details-column {
            width: 50%;
            float: left;
        }

        p {
            font-size: 13px;
            line-height: 1.2;
            margin: 2px 0;
        }

        .invoice-line {
            border-top: 1px solid #4b5563;
            margin-top: 20px;
        }

        .divider {
            margin-top: 30px;
        }
    </style>
</head>
<body>
<h3><?php echo e(__('Invoice #') . $invoice->invoice); ?></h3>
<p><?php echo e(__('Invoice date: ') . date('Y-m-d')); ?></p>


<div class="details-row">
    <div class="details-column">
        <h5><?php echo e(__('ISP Details:')); ?></h5>
        <p><?php echo e($company->name); ?></p>
        <p><?php echo e(__('Address: ') . $company->address); ?></p>
        <p><?php echo e(__('Phone: ') . $company->phone); ?></p>
        <p><?php echo e(__('Email: ') . $company->email); ?></p>
    </div>

    <div class="details-column">
        <h5><?php echo e(__('Invoice Details:')); ?></h5>
        <p><?php echo e(__('Customer: ') . $invoice->user->name); ?></p>
        <p><?php echo e(__('Address: ') . $invoice->user->detail->address); ?></p>
        <p><?php echo e(__('Phone: ') . $invoice->user->detail->phone); ?></p>
        <p><?php echo e(__('Email: ') . $invoice->user->email); ?></p>
    </div>
</div>

<div class="divider"></div>

<table>
    <tr>
        <th><?php echo e(__('Description')); ?></th>
        <th><?php echo e(__('Amount')); ?></th>
    </tr>
    <tr>
        <td>
            <?php echo e(__('Package name ') . $invoice->billing->package_name); ?><br>
            <?php echo e(__('(Started on ') . $invoice->billing->package_start . __(')')); ?>

        </td>
        <td><?php echo e(config('app.currency') . $invoice->package_price); ?></td>
    </tr>
    <tr class="invoice-line">
        <td colspan="1" style="text-align: right;"><?php echo e(__('Total:')); ?></td>
        <td><?php echo e(config('app.currency') . $invoice->package_price); ?></td>
    </tr>
</table>

</body>
</html>
<?php /**PATH C:\wamp64\www\betternet 4\resources\views/reports/invoice.blade.php ENDPATH**/ ?>